﻿using System;
using System.Data;
using NHibernate.SqlTypes;
using NHibernate.UserTypes;
using libsecondlife;

namespace OpenSim.Framework.Data.Hibernate.Utils
{
    [Serializable]
    public class LLUUIDToStringConverter : IUserType 
    {


        #region IUserType Members

        public object Assemble(object cached, object owner)
        {
            return cached;
        }

        bool IUserType.Equals(object x, object y)
        {
            return x.Equals(y);
        }



        public object DeepCopy(object value)
        {
            return value;
        }

        public object Disassemble(object value)
        {
            return value;
        }

        public int GetHashCode(object x)
        {
            return (x == null) ? 0 : x.GetHashCode();
        }

        public bool IsMutable
        {
            get { return false; }
        }

        public object NullSafeGet(System.Data.IDataReader rs, string[] names, object owner)
        {
            object RetVal = null; 

            int ord = rs.GetOrdinal(names[0]);
            if (!rs.IsDBNull(ord))
            {

                string first = (string)rs.GetString(ord);
                RetVal = new LLUUID(first);
            }

            return RetVal;
        }

        public void NullSafeSet(System.Data.IDbCommand cmd, object value, int index)
        {
            //throw new NotImplementedException();
            LLUUID Guid = (LLUUID)value;
            ((IDataParameter)cmd.Parameters[index]).Value = Guid.ToString();
        }

        public object Replace(object original, object target, object owner)
        {
            return original;
        }

        public Type ReturnedType
        {
            get { return typeof(LLUUID); }
        }

        public SqlType[] SqlTypes
        {
            get { return new SqlType [] { SqlTypeFactory.GetString(32) }; }
        }

        #endregion
    }
}
